function error = mispricing_CDS(c, cds, discounts, discounts_inbetween)
% --------------------------------------------------------------------------------------------------
% Wrapper function that calculates the squared pricing error for a credit default swap. The first
% argument overwrites the coupon rate in 'cds' in order to be able to apply Newton-Raphson to this
% function.
% --------------------------------------------------------------------------------------------------
% c                     ... coupon rate
% cds                   ... structure containing credit default swap time series (see 'all_steps_in_a_row.m')
% discounts             ... discount curve (quarterly frequency, end of period)
% discounts_inbetween   ... discount curve (quarterly frequency, middle of period)
% --------------------------------------------------------------------------------------------------
% sample call: mispricing_CDS([100; 200], cds_test, exp(-0.05*repmat(0.25:0.25:5, 2, 1)), exp(-0.05*repmat((0.25:0.25:5)-1/8, 2, 1)))
% --------------------------------------------------------------------------------------------------

cds.market_price = c;
error = value_fixed_leg_CDS(cds, discounts, discounts_inbetween) - value_default_leg_CDS(cds, discounts, discounts_inbetween);
error = error.^2;